@extends('layouts.admin')
@section('page-title')
    {{__('Dashboard')}}
@endsection
@push('script-page')
    <script>
        @if(\Auth::user()->can('show account dashboard'))
        (function () {
            var chartBarOptions = {
                series: [
                    {
                        name: "{{__('Income')}}",
                        data:{!! json_encode($incExpLineChartData['income']) !!}
                    },
                    {
                        name: "{{__('Expense')}}",
                        data: {!! json_encode($incExpLineChartData['expense']) !!}
                    }
                ],

                chart: {
                    height: 250,
                    type: 'area',
                    // type: 'line',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories:{!! json_encode($incExpLineChartData['day']) !!},
                    title: {
                        text: '{{ __("Date") }}'
                    }
                },
                colors: ['#6fd944', '#ff3a6e'],


                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                // markers: {
                //     size: 4,
                //     colors: ['#6fd944', '#FF3A6E'],
                //     opacity: 0.9,
                //     strokeWidth: 2,
                //     hover: {
                //         size: 7,
                //     }
                // },
                yaxis: {
                    title: {
                        text: '{{ __("Amount") }}'
                    },

                }

            };
            var arChart = new ApexCharts(document.querySelector("#cash-flow"), chartBarOptions);
            arChart.render();
        })();

        (function () {
            var options = {
                chart: {
                    height: 180,
                    type: 'bar',
                    toolbar: {
                        show: false,
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                series: [{
                    name: "{{__('Income')}}",
                    data: {!! json_encode($incExpBarChartData['income']) !!}
                }, {
                    name: "{{__('Expense')}}",
                    data: {!! json_encode($incExpBarChartData['expense']) !!}
                }],
                xaxis: {
                    categories: {!! json_encode($incExpBarChartData['month']) !!},
                },
                colors: ['#3ec9d6', '#FF3A6E'],
                fill: {
                    type: 'solid',
                },
                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: true,
                    position: 'top',
                    horizontalAlign: 'right',
                },
                // markers: {
                //     size: 4,
                //     colors:  ['#3ec9d6', '#FF3A6E',],
                //     opacity: 0.9,
                //     strokeWidth: 2,
                //     hover: {
                //         size: 7,
                //     }
                // }
            };
            var chart = new ApexCharts(document.querySelector("#incExpBarChart"), options);
            chart.render();
        })();

        (function () {
            var options = {
                chart: {
                    height: 200,
                    type: 'donut',
                },
                dataLabels: {
                    enabled: false,
                },
                plotOptions: {
                    pie: {
                        donut: {
                            size: '75%',
                        }
                    }
                },
                series: {!! json_encode($expenseCatAmount) !!},
                colors: {!! json_encode($expenseCategoryColor) !!},
                labels: {!! json_encode($expenseCategory) !!},
                legend: {
                    show: true
                }
            };
            var chart = new ApexCharts(document.querySelector("#expenseByCategory"), options);
            chart.render();
        })();

        (function () {
            var options = {
                chart: {
                    height: 200,
                    type: 'donut',
                },
                dataLabels: {
                    enabled: false,
                },
                plotOptions: {
                    pie: {
                        donut: {
                            size: '75%',
                        }
                    }
                },
                series: {!! json_encode($incomeCatAmount) !!},
                colors: {!! json_encode($incomeCategoryColor) !!},
                labels:  {!! json_encode($incomeCategory) !!},
                legend: {
                    show: true
                }
            };
            var chart = new ApexCharts(document.querySelector("#incomeByCategory"), options);
            chart.render();
        })();

        (function () {
            var options = {
                series: [{{ round($storage_limit,2) }}],
                chart: {
                    height: 400,
                    type: 'radialBar',
                    offsetY: -20,
                    sparkline: {
                        enabled: true
                    }
                },
                plotOptions: {
                    radialBar: {
                        startAngle: -90,
                        endAngle: 90,
                        track: {
                            background: "#e7e7e7",
                            strokeWidth: '97%',
                            margin: 5, // margin is in pixels
                        },
                        dataLabels: {
                            name: {
                                show: true
                            },
                            value: {
                                offsetY: -50,
                                fontSize: '20px'
                            }
                        }
                    }
                },
                grid: {
                    padding: {
                        top: -10
                    }
                },
                colors: ["#6FD943"],
                labels: ['Used'],
            };
            var chart = new ApexCharts(document.querySelector("#limit-chart"), options);
            chart.render();
        })();

        @endif
    </script>
@endpush
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Account')}}</li>
@endsection
@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-xxl-7">
                    <div class="row gy-4 mb-4 dash-row">
                        <div class="col-sm-6 col-12 dash-info-card">
                            <div class="info-card-inner card mb-0">
                                <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                                        fill="#FF3A6E" />
                                    <path opacity="0.4"
                                        d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                                        fill="#FF3A6E" />
                                </svg>
                                <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                        fill="#FF3A6E"></path>
                                </svg>
                                <div
                                    class="info-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                                    <div class="info-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_63_1528)">
                                                <path
                                                    d="M12 9.68585C14.2523 9.68585 16.0781 7.86001 16.0781 5.60773C16.0781 3.35544 14.2523 1.5296 12 1.5296C9.74771 1.5296 7.92188 3.35544 7.92188 5.60773C7.92188 7.86001 9.74771 9.68585 12 9.68585Z"
                                                    fill="white" />
                                                <path
                                                    d="M20.25 9.68579C21.6739 9.68579 22.8281 8.53153 22.8281 7.10767C22.8281 5.68381 21.6739 4.52954 20.25 4.52954C18.8261 4.52954 17.6719 5.68381 17.6719 7.10767C17.6719 8.53153 18.8261 9.68579 20.25 9.68579Z"
                                                    fill="white" />
                                                <path
                                                    d="M3.75 9.68579C5.17386 9.68579 6.32812 8.53153 6.32812 7.10767C6.32812 5.68381 5.17386 4.52954 3.75 4.52954C2.32614 4.52954 1.17188 5.68381 1.17188 7.10767C1.17188 8.53153 2.32614 9.68579 3.75 9.68579Z"
                                                    fill="white" />
                                                <path
                                                    d="M6.29016 12.001C5.27531 11.1695 4.35623 11.2796 3.18281 11.2796C1.42781 11.2796 0 12.699 0 14.4432V19.5624C0 20.3199 0.618281 20.9359 1.37859 20.9359C4.66106 20.9359 4.26562 20.9952 4.26562 20.7943C4.26562 17.1668 3.83597 14.5066 6.29016 12.001Z"
                                                    fill="white" />
                                                <path
                                                    d="M13.1161 11.2983C11.0665 11.1273 9.28506 11.3003 7.74845 12.5686C5.17703 14.6283 5.67189 17.4016 5.67189 20.7942C5.67189 21.6918 6.4022 22.4358 7.31345 22.4358C17.2079 22.4358 17.6017 22.755 18.1885 21.4556C18.3809 21.0162 18.3281 21.1559 18.3281 16.9524C18.3281 13.6136 15.4372 11.2983 13.1161 11.2983Z"
                                                    fill="white" />
                                                <path
                                                    d="M20.8172 11.2795C19.6373 11.2795 18.7233 11.1706 17.7098 12.001C20.1457 14.488 19.7344 16.9667 19.7344 20.7942C19.7344 20.9965 19.4061 20.9358 22.5722 20.9358C23.3597 20.9358 24 20.2978 24 19.5136V14.4431C24 12.6989 22.5722 11.2795 20.8172 11.2795Z"
                                                    fill="white" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_63_1528">
                                                    <rect width="24" height="24" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                    <h3 class="mb-0">{{ \Auth::user()->countCustomers() }}</h3>
                                </div>
                                <div class="info-content">
                                    <h2 class="h4 mb-0"><a href="{{ route('customer.index') }}"
                                            class="info-link dashboard-link">{{ __('Total Customers') }}</a></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-12 dash-info-card">
                            <div class="info-card-inner card mb-0">
                                <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                                        fill="#FF3A6E" />
                                    <path opacity="0.4"
                                        d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                                        fill="#FF3A6E" />
                                </svg>
                                <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                        fill="#FF3A6E"></path>
                                </svg>
                                <div
                                    class="info-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                                    <div class="info-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_9243_1544)">
                                            <path d="M1.5 21.75C1.5 22.9875 2.51249 24 3.75 24H20.25C21.4875 24 22.5 22.9875 22.5 21.75V20.25H1.5V21.75Z" fill="white"/>
                                            <path d="M22.4998 15.0005C22.499 12.4139 22.4982 9.82724 22.4974 7.24061C23.3525 6.94616 23.8412 5.99713 23.8772 5.09351C23.9131 4.1899 23.5896 3.31518 23.271 2.46884C22.9343 1.57463 22.5183 0.59307 21.6453 0.20466C21.1835 -0.000809863 20.6608 -0.00410235 20.1553 -0.00389985C14.6736 -0.00172486 9.19184 0.000457645 3.7101 0.00263264C3.19035 0.00283515 2.64657 0.00875264 2.18778 0.25302C1.53258 0.60186 1.20801 1.34415 0.930342 2.03252C0.530929 3.02268 0.117529 4.05641 0.114717 5.14069C0.112437 6.01971 0.706834 6.86912 1.50129 7.24142C1.50095 9.82947 1.5006 12.4175 1.50024 15.0055C0.457459 14.8907 -0.0434732 16.0718 -0.0390332 16.9251C-0.0359357 17.5196 0.151842 18.1662 0.649699 18.4911C1.03711 18.7439 1.52925 18.7522 1.99185 18.7521C8.72269 18.7512 15.4535 18.7502 22.1844 18.7493C22.5385 18.7492 22.9079 18.7457 23.2233 18.5848C23.741 18.3207 23.9761 17.7009 24.0254 17.1218C24.1024 16.2182 23.6304 14.9101 22.4998 15.0005ZM2.99996 7.47414C3.39873 7.41762 3.8189 7.25008 4.14693 7.01711C4.35164 6.87173 4.6479 6.87173 4.85445 7.01785C5.74727 7.6492 7.00117 7.64993 7.89693 7.01711C8.10164 6.87173 8.39827 6.87173 8.60445 7.01785C9.49727 7.6492 10.7512 7.64993 11.6469 7.01711C11.8513 6.87173 12.1479 6.87173 12.3544 7.01785C13.2465 7.6492 14.5019 7.64993 15.3969 7.01711C15.5998 6.87246 15.8972 6.87136 16.1044 7.01785C16.9965 7.6492 18.2519 7.64993 19.1469 7.01711C19.3498 6.87246 19.6472 6.87136 19.8544 7.01785C20.1877 7.25374 20.5974 7.412 21 7.47414V15.0005H16.243C15.7768 13.6844 14.7163 12.6721 13.4119 12.238C13.9189 11.8251 14.25 11.2039 14.25 10.5005C14.25 9.25979 13.2407 8.25051 12 8.25051C10.7592 8.25051 9.74995 9.25979 9.74995 10.5005C9.74995 11.2039 10.081 11.8251 10.588 12.238C9.28381 12.6721 8.2234 13.6844 7.75726 15.0005H2.99995C2.99995 15.0005 2.99995 7.47414 2.99996 7.47414Z" fill="white"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_9243_1544">
                                            <rect width="24" height="24" fill="white"/>
                                            </clipPath>
                                            </defs>
                                            </svg>

                                    </div>

                                    <h3 class="mb-0">{{ \Auth::user()->countVenders() }}</h3>
                                </div>
                                <div class="info-content">
                                    <h2 class="h4 mb-0"><a href="{{ route('vender.index') }}"
                                            class="info-link dashboard-link">{{ __('Total Vendors') }}</a></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-12 dash-info-card">
                            <div class="info-card-inner card mb-0">
                                <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                                        fill="#FF3A6E" />
                                    <path opacity="0.4"
                                        d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                                        fill="#FF3A6E" />
                                </svg>
                                <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                        fill="#FF3A6E"></path>
                                </svg>
                                <div
                                    class="info-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                                    <div class="info-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_9243_1550)">
                                            <path d="M19.2656 0.410156V4.68595H23.5411L19.2656 0.410156Z" fill="white"/>
                                            <path d="M18.5625 6.09375C18.1742 6.09375 17.8594 5.77894 17.8594 5.39062V0H7.78125C6.61814 0 5.67188 0.946266 5.67188 2.10938V9.9698C5.90353 9.9488 6.13795 9.9375 6.375 9.9375C8.77163 9.9375 10.917 11.0332 12.3368 12.75H19.9688C20.3571 12.75 20.6719 13.0648 20.6719 13.4531C20.6719 13.8414 20.3571 14.1562 19.9688 14.1562H13.2632C13.7027 15.0139 13.9861 15.964 14.0771 16.9688H19.9688C20.3571 16.9688 20.6719 17.2836 20.6719 17.6719C20.6719 18.0602 20.3571 18.375 19.9688 18.375H14.0771C13.8668 20.6971 12.6261 22.7262 10.8168 24H21.8438C23.0069 24 23.9531 23.0537 23.9531 21.8906V6.09375H18.5625ZM19.9688 9.9375H9.65625C9.26794 9.9375 8.95312 9.62269 8.95312 9.23438C8.95312 8.84606 9.26794 8.53125 9.65625 8.53125H19.9688C20.3571 8.53125 20.6719 8.84606 20.6719 9.23438C20.6719 9.62269 20.3571 9.9375 19.9688 9.9375Z" fill="white"/>
                                            <path d="M6.375 11.3438C2.88567 11.3438 0.046875 14.1825 0.046875 17.6719C0.046875 21.1612 2.88567 24 6.375 24C9.86433 24 12.7031 21.1612 12.7031 17.6719C12.7031 14.1825 9.86433 11.3438 6.375 11.3438ZM5.98439 16.9688H6.76566C7.58409 16.9688 8.25 17.6347 8.25 18.4531V19.2344C8.25 19.9456 7.74703 20.5414 7.07812 20.6854V20.9531C7.07812 21.3414 6.76331 21.6562 6.375 21.6562C5.98669 21.6562 5.67188 21.3414 5.67188 20.9531V20.6854C5.00297 20.5414 4.5 19.9456 4.5 19.2344C4.5 18.846 4.81481 18.5312 5.20312 18.5312C5.59144 18.5312 5.90625 18.846 5.90625 19.2344C5.90625 19.2774 5.94131 19.3125 5.98439 19.3125H6.76566C6.80873 19.3125 6.8438 19.2774 6.8438 19.2344V18.4531C6.8438 18.4101 6.80873 18.375 6.76566 18.375H5.98439C5.16591 18.375 4.5 17.7091 4.5 16.8906V16.1094C4.5 15.3981 5.00297 14.8023 5.67188 14.6584V14.3906C5.67188 14.0023 5.98669 13.6875 6.375 13.6875C6.76331 13.6875 7.07812 14.0023 7.07812 14.3906V14.6584C7.74703 14.8023 8.25 15.3981 8.25 16.1094C8.25 16.4977 7.93519 16.8125 7.54688 16.8125C7.15856 16.8125 6.84375 16.4977 6.84375 16.1094C6.84375 16.0663 6.80869 16.0312 6.76561 16.0312H5.98434C5.94127 16.0312 5.9062 16.0663 5.9062 16.1094V16.8906C5.90625 16.9337 5.94131 16.9688 5.98439 16.9688Z" fill="white"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_9243_1550">
                                            <rect width="24" height="24" fill="white"/>
                                            </clipPath>
                                            </defs>
                                            </svg>

                                    </div>
                                    <h3 class="mb-0">{{ \Auth::user()->countInvoices() }}</h3>
                                </div>
                                <div class="info-content">
                                    <h2 class="h4 mb-0"><a href="{{ route('invoice.index') }}"
                                            class="info-link dashboard-link">{{ __('Total Invoices') }}</a></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-12 dash-info-card">
                            <div class="info-card-inner card mb-0">
                                <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4"
                                        d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                                        fill="#FF3A6E" />
                                    <path opacity="0.4"
                                        d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                                        fill="#FF3A6E" />
                                </svg>
                                <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                        fill="#FF3A6E"></path>
                                </svg>
                                <div
                                    class="info-icon-wrp d-flex flex-wrap justify-content-between gap-2">
                                    <div class="info-icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M17.1075 2.07787C16.8462 1.94147 16.552 1.88046 16.258 1.90166C15.964 1.92285 15.6816 2.02541 15.4425 2.19787C15.2446 2.35421 14.997 2.43408 14.745 2.42287C14.4467 2.42616 14.1589 2.31318 13.9425 2.10787C13.4629 1.71964 12.8646 1.50781 12.2475 1.50781C11.6305 1.50781 11.0321 1.71964 10.5525 2.10787C10.3329 2.31037 10.045 2.4228 9.74627 2.4228C9.4475 2.4228 9.15968 2.31037 8.94002 2.10787C8.46183 1.7197 7.86467 1.50784 7.24877 1.50784C6.63286 1.50784 6.0357 1.7197 5.55752 2.10787C5.339 2.31459 5.04829 2.42765 4.74752 2.42287C4.50007 2.43448 4.25704 2.35436 4.06502 2.19787C3.82456 2.0248 3.54044 1.92253 3.24484 1.90265C2.94924 1.88276 2.65399 1.94606 2.39252 2.08537C2.1226 2.22418 1.89636 2.43498 1.73884 2.69443C1.58132 2.95387 1.49866 3.25185 1.50002 3.55537V19.3579C1.5 19.7929 1.67178 20.2103 1.97797 20.5193C2.28417 20.8283 2.70001 21.0039 3.13502 21.0079H13.14C12.396 20.0377 11.995 18.848 12 17.6254C12 16.1335 12.5926 14.7028 13.6475 13.6479C14.7024 12.593 16.1332 12.0004 17.625 12.0004C17.7504 12.0004 17.8756 12.0079 18 12.0229V3.54787C18.0008 3.24447 17.9179 2.94674 17.7604 2.6874C17.603 2.42806 17.3771 2.21715 17.1075 2.07787ZM5.70002 16.0504C5.52201 16.0504 5.34801 15.9976 5.2 15.8987C5.052 15.7998 4.93664 15.6592 4.86852 15.4948C4.80041 15.3303 4.78258 15.1494 4.81731 14.9748C4.85204 14.8002 4.93775 14.6398 5.06362 14.514C5.18949 14.3881 5.34985 14.3024 5.52444 14.2677C5.69902 14.2329 5.87998 14.2508 6.04443 14.3189C6.20889 14.387 6.34945 14.5023 6.44834 14.6504C6.54723 14.7984 6.60002 14.9724 6.60002 15.1504C6.60002 15.3891 6.5052 15.618 6.33641 15.7868C6.16763 15.9555 5.93871 16.0504 5.70002 16.0504ZM5.70002 12.3004C5.52201 12.3004 5.34801 12.2476 5.2 12.1487C5.052 12.0498 4.93664 11.9092 4.86852 11.7448C4.80041 11.5803 4.78258 11.3994 4.81731 11.2248C4.85204 11.0502 4.93775 10.8898 5.06362 10.764C5.18949 10.6381 5.34985 10.5524 5.52444 10.5177C5.69902 10.4829 5.87998 10.5008 6.04443 10.5689C6.20889 10.637 6.34945 10.7523 6.44834 10.9004C6.54723 11.0484 6.60002 11.2224 6.60002 11.4004C6.60002 11.6391 6.5052 11.868 6.33641 12.0368C6.16763 12.2055 5.93871 12.3004 5.70002 12.3004ZM5.70002 8.40037C5.5217 8.40036 5.34739 8.34738 5.19923 8.24815C5.05107 8.14892 4.93572 8.00792 4.86783 7.84303C4.79994 7.67813 4.78256 7.49679 4.8179 7.32201C4.85324 7.14722 4.9397 6.98688 5.06632 6.86131C5.19294 6.73575 5.354 6.65063 5.52908 6.61675C5.70415 6.58288 5.88534 6.60178 6.04966 6.67105C6.21398 6.74032 6.35401 6.85684 6.452 7.00583C6.54998 7.15481 6.6015 7.32955 6.60002 7.50787C6.59952 7.62556 6.57586 7.74201 6.53036 7.85056C6.48487 7.95911 6.41843 8.05764 6.33486 8.14051C6.25129 8.22339 6.15221 8.28899 6.04328 8.33358C5.93436 8.37817 5.81771 8.40086 5.70002 8.40037ZM10.5 15.9004H8.40002C8.2011 15.9004 8.01034 15.8213 7.86969 15.6807C7.72903 15.54 7.65002 15.3493 7.65002 15.1504C7.65002 14.9515 7.72903 14.7607 7.86969 14.62C8.01034 14.4794 8.2011 14.4004 8.40002 14.4004H10.5C10.6989 14.4004 10.8897 14.4794 11.0303 14.62C11.171 14.7607 11.25 14.9515 11.25 15.1504C11.25 15.3493 11.171 15.54 11.0303 15.6807C10.8897 15.8213 10.6989 15.9004 10.5 15.9004ZM13.95 12.1504H8.40002C8.2011 12.1504 8.01034 12.0713 7.86969 11.9307C7.72903 11.79 7.65002 11.5993 7.65002 11.4004C7.65002 11.2015 7.72903 11.0107 7.86969 10.87C8.01034 10.7294 8.2011 10.6504 8.40002 10.6504H13.95C14.1489 10.6504 14.3397 10.7294 14.4803 10.87C14.621 11.0107 14.7 11.2015 14.7 11.4004C14.7 11.5993 14.621 11.79 14.4803 11.9307C14.3397 12.0713 14.1489 12.1504 13.95 12.1504ZM13.95 8.25787H8.40002C8.2011 8.25787 8.01034 8.17885 7.86969 8.0382C7.72903 7.89754 7.65002 7.70678 7.65002 7.50787C7.65002 7.30895 7.72903 7.11819 7.86969 6.97754C8.01034 6.83688 8.2011 6.75787 8.40002 6.75787H13.95C14.1489 6.75787 14.3397 6.83688 14.4803 6.97754C14.621 7.11819 14.7 7.30895 14.7 7.50787C14.7 7.70678 14.621 7.89754 14.4803 8.0382C14.3397 8.17885 14.1489 8.25787 13.95 8.25787Z" fill="white"/>
                                            <path d="M17.625 12.75C16.6608 12.75 15.7183 13.0359 14.9166 13.5716C14.1149 14.1073 13.4901 14.8686 13.1211 15.7594C12.7521 16.6502 12.6556 17.6304 12.8437 18.5761C13.0318 19.5217 13.4961 20.3904 14.1779 21.0721C14.8596 21.7539 15.7283 22.2182 16.6739 22.4063C17.6196 22.5944 18.5998 22.4979 19.4906 22.1289C20.3814 21.7599 21.1427 21.1351 21.6784 20.3334C22.2141 19.5317 22.5 18.5892 22.5 17.625C22.4984 16.3326 21.9843 15.0935 21.0704 14.1796C20.1565 13.2657 18.9174 12.7516 17.625 12.75ZM19.6553 17.1555L17.6558 19.1558C17.5861 19.2255 17.5034 19.2808 17.4123 19.3185C17.3213 19.3563 17.2237 19.3757 17.1251 19.3757C17.0266 19.3757 16.929 19.3563 16.8379 19.3185C16.7469 19.2808 16.6642 19.2255 16.5945 19.1558L15.5948 18.1553C15.4581 18.0138 15.3825 17.8243 15.3842 17.6277C15.386 17.4311 15.4648 17.2429 15.6039 17.1039C15.7429 16.9648 15.9311 16.886 16.1277 16.8842C16.3243 16.8825 16.5138 16.9581 16.6553 17.0947L17.1248 17.5643L18.5948 16.0942C18.6644 16.0246 18.7471 15.9694 18.8382 15.9317C18.9292 15.8941 19.0268 15.8747 19.1253 15.8747C19.2238 15.8748 19.3213 15.8942 19.4123 15.9319C19.5033 15.9697 19.586 16.0249 19.6556 16.0946C19.7253 16.1643 19.7805 16.247 19.8182 16.338C19.8558 16.4291 19.8752 16.5266 19.8752 16.6251C19.8751 16.7237 19.8557 16.8212 19.818 16.9122C19.7802 17.0032 19.7249 17.0859 19.6553 17.1555Z" fill="white"/>
                                            </svg>

                                    </div>

                                    <h3 class="mb-0">{{ \Auth::user()->countBills() }}</h3>
                                </div>
                                <div class="info-content">
                                    <h2 class="h4 mb-0"><a href="{{ route('bill.index') }}"
                                            class="info-link dashboard-link">{{ __('Total Bills') }}</a></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Account Balance')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>{{__('Bank')}}</th>
                                        <th>{{__('Holder Name')}}</th>
                                        <th>{{__('Balance')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($bankAccountDetail as $bankAccount)

                                        <tr class="font-style">
                                            <td>{{$bankAccount->bank_name}}</td>
                                            <td>{{$bankAccount->holder_name}}</td>
                                            <td>{{\Auth::user()->priceFormat($bankAccount->opening_balance)}}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4">
                                                <div class="text-center">
                                                    <h6>{{__('there is no account balance')}}</h6>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card income-card">
                        <div class="card-header header-icon py-3">
                            <h5>{{__('Income Vs Expense')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="income-card-inner d-flex justify-content-between">
                                <div class="income-card-left">
                                    <div class="income-info iday">
                                        <div class="income-icon-wrp d-flex align-items-center">
                                            <div class="income-icon">
                                                <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_28_708)">
                                                    <path d="M3.03684 12.5408C3.56251 13.0111 4.15863 13.3839 4.79751 13.6642L8.15734 11.5544C8.85242 11.1158 9.78342 11.2195 10.3653 11.8046L11.495 12.9343C13.1884 11.6858 14.25 9.68844 14.25 7.52085C14.25 3.81031 11.2314 0.791687 7.52084 0.791687C3.8103 0.791687 0.791672 3.81031 0.791672 7.52085C0.791672 9.4359 1.60946 11.2654 3.03684 12.5408ZM7.82167 8.1146H7.22001C6.29455 8.1146 5.54167 7.36173 5.54167 6.43627C5.54167 5.60423 6.14176 4.91944 6.92709 4.7801V4.15627C6.92709 3.82852 7.19309 3.56252 7.52084 3.56252C7.84859 3.56252 8.11459 3.82852 8.11459 4.15627V4.75002H8.90626C9.23401 4.75002 9.50001 5.01602 9.50001 5.34377C9.50001 5.67152 9.23401 5.93752 8.90626 5.93752H7.22001C6.94926 5.93752 6.72917 6.1576 6.72917 6.42835C6.72917 6.70702 6.94926 6.9271 7.22001 6.9271H7.82167C8.74713 6.9271 9.50001 7.67998 9.50001 8.60544C9.50001 9.43748 8.89992 10.1223 8.11459 10.2616V10.8846C8.11459 11.2124 7.84859 11.4784 7.52084 11.4784C7.19309 11.4784 6.92709 11.2124 6.92709 10.8846V10.2917H6.13542C5.80767 10.2917 5.54167 10.0257 5.54167 9.69794C5.54167 9.37019 5.80767 9.10419 6.13542 9.10419H7.82167C8.09242 9.10419 8.31251 8.8841 8.31251 8.61335C8.31251 8.33469 8.09242 8.1146 7.82167 8.1146Z" fill="white"/>
                                                    <path d="M18.2083 9.5H15.0417C14.7218 9.5 14.4321 9.69317 14.3102 9.98846C14.1875 10.2845 14.2555 10.625 14.482 10.8514L15.5056 11.875L12.2708 15.1098L9.66388 12.5028C9.405 12.2423 8.99809 12.1972 8.68775 12.3896L0.375252 17.5354C0.00316851 17.7658 -0.110832 18.2535 0.118752 18.6247C0.268377 18.867 0.527252 19 0.79246 19C0.93496 19 1.07825 18.962 1.20809 18.8813L8.987 14.0655L11.7103 16.7889C12.0199 17.0984 12.5202 17.0984 12.8298 16.7889L16.625 12.9944L17.6486 14.018C17.7998 14.1693 18.0025 14.25 18.2083 14.25C18.3105 14.25 18.4134 14.2302 18.5115 14.1898C18.8076 14.0671 19 13.7782 19 13.4583V10.2917C19 9.85467 18.6461 9.5 18.2083 9.5Z" fill="white"/>
                                                    </g>
                                                    <defs>
                                                    <clipPath id="clip0_28_708">
                                                    <rect width="19" height="19" fill="white"/>
                                                    </clipPath>
                                                    </defs>
                                                </svg>
                                            </div>
                                            <div class="income-text">
                                                <span>{{__('Income Today')}}</span>
                                            </div>
                                        </div>
                                        <h4 class="mb-2">{{\Auth::user()->priceFormat(\Auth::user()->todayIncome())}}</h4>
                                        <div class="progress-line"></div>
                                    </div>
                                    <div class="income-info imonth">
                                        <div class="income-icon-wrp d-flex align-items-center">
                                            <div class="income-icon">
                                                <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_28_708)">
                                                    <path d="M3.03684 12.5408C3.56251 13.0111 4.15863 13.3839 4.79751 13.6642L8.15734 11.5544C8.85242 11.1158 9.78342 11.2195 10.3653 11.8046L11.495 12.9343C13.1884 11.6858 14.25 9.68844 14.25 7.52085C14.25 3.81031 11.2314 0.791687 7.52084 0.791687C3.8103 0.791687 0.791672 3.81031 0.791672 7.52085C0.791672 9.4359 1.60946 11.2654 3.03684 12.5408ZM7.82167 8.1146H7.22001C6.29455 8.1146 5.54167 7.36173 5.54167 6.43627C5.54167 5.60423 6.14176 4.91944 6.92709 4.7801V4.15627C6.92709 3.82852 7.19309 3.56252 7.52084 3.56252C7.84859 3.56252 8.11459 3.82852 8.11459 4.15627V4.75002H8.90626C9.23401 4.75002 9.50001 5.01602 9.50001 5.34377C9.50001 5.67152 9.23401 5.93752 8.90626 5.93752H7.22001C6.94926 5.93752 6.72917 6.1576 6.72917 6.42835C6.72917 6.70702 6.94926 6.9271 7.22001 6.9271H7.82167C8.74713 6.9271 9.50001 7.67998 9.50001 8.60544C9.50001 9.43748 8.89992 10.1223 8.11459 10.2616V10.8846C8.11459 11.2124 7.84859 11.4784 7.52084 11.4784C7.19309 11.4784 6.92709 11.2124 6.92709 10.8846V10.2917H6.13542C5.80767 10.2917 5.54167 10.0257 5.54167 9.69794C5.54167 9.37019 5.80767 9.10419 6.13542 9.10419H7.82167C8.09242 9.10419 8.31251 8.8841 8.31251 8.61335C8.31251 8.33469 8.09242 8.1146 7.82167 8.1146Z" fill="white"/>
                                                    <path d="M18.2083 9.5H15.0417C14.7218 9.5 14.4321 9.69317 14.3102 9.98846C14.1875 10.2845 14.2555 10.625 14.482 10.8514L15.5056 11.875L12.2708 15.1098L9.66388 12.5028C9.405 12.2423 8.99809 12.1972 8.68775 12.3896L0.375252 17.5354C0.00316851 17.7658 -0.110832 18.2535 0.118752 18.6247C0.268377 18.867 0.527252 19 0.79246 19C0.93496 19 1.07825 18.962 1.20809 18.8813L8.987 14.0655L11.7103 16.7889C12.0199 17.0984 12.5202 17.0984 12.8298 16.7889L16.625 12.9944L17.6486 14.018C17.7998 14.1693 18.0025 14.25 18.2083 14.25C18.3105 14.25 18.4134 14.2302 18.5115 14.1898C18.8076 14.0671 19 13.7782 19 13.4583V10.2917C19 9.85467 18.6461 9.5 18.2083 9.5Z" fill="white"/>
                                                    </g>
                                                    <defs>
                                                    <clipPath id="clip0_28_708">
                                                    <rect width="19" height="19" fill="white"/>
                                                    </clipPath>
                                                    </defs>
                                                </svg>
                                            </div>
                                            <div class="income-text">
                                                <span>{{__('Income This Month')}}</span>
                                            </div>
                                        </div>
                                        <h4 class="mb-2">{{\Auth::user()->priceFormat(\Auth::user()->incomeCurrentMonth())}}</h4>
                                        <div class="progress-line"></div>
                                    </div>
                                </div>
                                <div class="income-card-right">
                                    <div class="income-info eday">
                                        <div class="income-icon-wrp d-flex align-items-center">
                                            <div class="income-icon">
                                                <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.6719 12.7656C11.6719 12.2517 11.6719 10.6875 13.1562 10.6875H16.125V8.90625C16.125 8.08777 15.4591 7.42188 14.6406 7.42188H1.875C1.05652 7.42188 0.390625 8.08777 0.390625 8.90625V16.625C0.390625 17.4435 1.05652 18.1094 1.875 18.1094H14.6406C15.4591 18.1094 16.125 17.4435 16.125 16.625V14.8438H13.1562C11.6719 14.8438 11.6719 13.2795 11.6719 12.7656Z" fill="white"/>
                                                <path d="M12.2656 6.82811V5.02846C12.2656 4.72178 12.1056 4.44361 11.8375 4.28449C11.5597 4.11942 11.2242 4.11378 10.9407 4.26846L5.8074 6.82811H12.2656Z" fill="white"/>
                                                <path d="M14.0469 13.3594C14.3748 13.3594 14.6406 13.0935 14.6406 12.7656C14.6406 12.4377 14.3748 12.1719 14.0469 12.1719C13.719 12.1719 13.4531 12.4377 13.4531 12.7656C13.4531 13.0935 13.719 13.3594 14.0469 13.3594Z" fill="white"/>
                                                <path d="M9.59376 4.27681V3.01301C9.59376 2.56147 9.31588 2.27469 9.05612 2.15683C8.74084 2.01373 8.39527 2.06658 8.13165 2.29784L2.96127 6.82815H4.47712L9.59376 4.27681Z" fill="white"/>
                                                <path d="M16.7188 11.2812H13.1562C12.6216 11.2812 12.2656 11.5339 12.2656 12.7656C12.2656 13.9974 12.6216 14.25 13.1562 14.25H16.7188C17.2098 14.25 17.6094 13.8504 17.6094 13.3594V12.1719C17.6094 11.6808 17.2098 11.2812 16.7188 11.2812ZM14.0469 13.9531C13.392 13.9531 12.8594 13.4205 12.8594 12.7656C12.8594 12.1107 13.392 11.5781 14.0469 11.5781C14.7018 11.5781 15.2344 12.1107 15.2344 12.7656C15.2344 13.4205 14.7018 13.9531 14.0469 13.9531Z" fill="white"/>
                                                <path d="M17.8406 2.61191L16.475 0.774847C16.2981 0.536753 15.9412 0.536753 15.7643 0.775144L14.407 2.603C14.2719 2.73808 14.3675 2.96875 14.5584 2.96875H15.2287C15.4101 3.85819 15.0105 4.76544 14.2321 5.23242L14.0469 5.34375L15.2344 6.23438L15.2866 6.19964C16.3667 5.47942 17.0156 4.26699 17.0156 2.96875H17.6928C17.8792 2.96875 17.9725 2.74372 17.8406 2.61191Z" fill="white"/>
                                                </svg>
                                            </div>
                                            <div class="income-text">
                                                <span>{{__('Expense Today')}}</span>
                                            </div>
                                        </div>
                                        <h4 class="mb-2">{{\Auth::user()->priceFormat(\Auth::user()->todayExpense())}}</h4>
                                        <div class="progress-line"></div>
                                    </div>
                                    <div class="income-info emonth">
                                        <div class="income-icon-wrp d-flex align-items-center">
                                            <div class="income-icon">
                                                <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.6719 12.7656C11.6719 12.2517 11.6719 10.6875 13.1562 10.6875H16.125V8.90625C16.125 8.08777 15.4591 7.42188 14.6406 7.42188H1.875C1.05652 7.42188 0.390625 8.08777 0.390625 8.90625V16.625C0.390625 17.4435 1.05652 18.1094 1.875 18.1094H14.6406C15.4591 18.1094 16.125 17.4435 16.125 16.625V14.8438H13.1562C11.6719 14.8438 11.6719 13.2795 11.6719 12.7656Z" fill="white"/>
                                                <path d="M12.2656 6.82811V5.02846C12.2656 4.72178 12.1056 4.44361 11.8375 4.28449C11.5597 4.11942 11.2242 4.11378 10.9407 4.26846L5.8074 6.82811H12.2656Z" fill="white"/>
                                                <path d="M14.0469 13.3594C14.3748 13.3594 14.6406 13.0935 14.6406 12.7656C14.6406 12.4377 14.3748 12.1719 14.0469 12.1719C13.719 12.1719 13.4531 12.4377 13.4531 12.7656C13.4531 13.0935 13.719 13.3594 14.0469 13.3594Z" fill="white"/>
                                                <path d="M9.59376 4.27681V3.01301C9.59376 2.56147 9.31588 2.27469 9.05612 2.15683C8.74084 2.01373 8.39527 2.06658 8.13165 2.29784L2.96127 6.82815H4.47712L9.59376 4.27681Z" fill="white"/>
                                                <path d="M16.7188 11.2812H13.1562C12.6216 11.2812 12.2656 11.5339 12.2656 12.7656C12.2656 13.9974 12.6216 14.25 13.1562 14.25H16.7188C17.2098 14.25 17.6094 13.8504 17.6094 13.3594V12.1719C17.6094 11.6808 17.2098 11.2812 16.7188 11.2812ZM14.0469 13.9531C13.392 13.9531 12.8594 13.4205 12.8594 12.7656C12.8594 12.1107 13.392 11.5781 14.0469 11.5781C14.7018 11.5781 15.2344 12.1107 15.2344 12.7656C15.2344 13.4205 14.7018 13.9531 14.0469 13.9531Z" fill="white"/>
                                                <path d="M17.8406 2.61191L16.475 0.774847C16.2981 0.536753 15.9412 0.536753 15.7643 0.775144L14.407 2.603C14.2719 2.73808 14.3675 2.96875 14.5584 2.96875H15.2287C15.4101 3.85819 15.0105 4.76544 14.2321 5.23242L14.0469 5.34375L15.2344 6.23438L15.2866 6.19964C16.3667 5.47942 17.0156 4.26699 17.0156 2.96875H17.6928C17.8792 2.96875 17.9725 2.74372 17.8406 2.61191Z" fill="white"/>
                                                </svg>
                                            </div>
                                            <div class="income-text">
                                                <span>{{__('Expense This Month')}}</span>
                                            </div>
                                        </div>
                                        <h4 class="mb-2">{{\Auth::user()->priceFormat(\Auth::user()->expenseCurrentMonth())}}</h4>
                                        <div class="progress-line"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card" style="height: 370px">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Cashflow')}}</h5>
                        </div>
                        <div class="card-body">
                            <div id="cash-flow"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7">
                    <div class="card">
                        <div class="card-header">
                            <h5>{{__('Income & Expense')}}
                                <span class="float-end text-muted">{{__('Current Year').' - '.$currentYear}}</span>
                            </h5>

                        </div>
                        <div class="card-body">
                            <div id="incExpBarChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card" style="height: 315px">
                        <div class="card-header">
                            <h5>{{__('Income By Category')}}
                                <span class="float-end text-muted">{{__('Year').' - '.$currentYear}}</span>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div id="incomeByCategory"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Latest Income')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>{{__('Date')}}</th>
                                        <th>{{__('Customer')}}</th>
                                        <th>{{__('Amount Due')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($latestIncome as $income)
                                        <tr>
                                            <td>{{\Auth::user()->dateFormat($income->date)}}</td>
                                            <td>{{!empty($income->customer)?$income->customer->name:'-'}}</td>
                                            <td>{{\Auth::user()->priceFormat($income->amount)}}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4">
                                                <div class="text-center">
                                                    <h6>{{__('There is no latest income')}}</h6>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card" style="height: 370px">
                        <div class="card-header">
                            <h5>{{__('Expense By Category')}}
                                <span class="float-end text-muted">{{__('Year').' - '.$currentYear}}</span>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div id="expenseByCategory"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Latest Expense')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>{{__('Date')}}</th>
                                        <th>{{__('Vendor')}}</th>
                                        <th>{{__('Amount Due')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($latestExpense as $expense)

                                        <tr>
                                            <td>{{\Auth::user()->dateFormat($expense->date)}}</td>
                                            <td>{{!empty($expense->vender)?$expense->vender->name:'-'}}</td>
                                            <td>{{\Auth::user()->priceFormat($expense->amount)}}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4">
                                                <div class="text-center">
                                                    <h6>{{__('There is no latest expense')}}</h6>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card" style="height: 370px">
                        <div class="card-header">
                            <h5>{{__('Storage Limit')}}
                                <small class="float-end text-muted">{{ $users->storage_limit . 'MB' }} / {{ $plan->storage_limit . 'MB' }}</small>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div id="limit-chart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Recent Invoices')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('Customer')}}</th>
                                        <th>{{__('Issue Date')}}</th>
                                        <th>{{__('Due Date')}}</th>
                                        <th>{{__('Amount')}}</th>
                                        <th>{{__('Status')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($recentInvoice as $invoice)
                                        <tr>
                                            <td>{{\Auth::user()->invoiceNumberFormat($invoice->invoice_id)}}</td>
                                            <td>{{!empty($invoice->customer_name)? $invoice->customer_name:'' }} </td>
                                            <td>{{ Auth::user()->dateFormat($invoice->issue_date) }}</td>
                                            <td>{{ Auth::user()->dateFormat($invoice->due_date) }}</td>
                                            <td>{{\Auth::user()->priceFormat($invoice->getTotal())}}</td>
                                            <td>
                                                @if($invoice->status == 0)
                                                    <span class="p-2 px-3 rounded badge status_badge bg-secondary">{{ __(\App\Models\Invoice::$statues[$invoice->status]) }}</span>
                                                @elseif($invoice->status == 1)
                                                    <span class="p-2 px-3 rounded badge status_badge bg-warning">{{ __(\App\Models\Invoice::$statues[$invoice->status]) }}</span>
                                                @elseif($invoice->status == 2)
                                                    <span class="p-2 px-3 rounded badge status_badge bg-danger">{{ __(\App\Models\Invoice::$statues[$invoice->status]) }}</span>
                                                @elseif($invoice->status == 3)
                                                    <span class="p-2 px-3 rounded badge status_badge bg-info">{{ __(\App\Models\Invoice::$statues[$invoice->status]) }}</span>
                                                @elseif($invoice->status == 4)
                                                    <span class="p-2 px-3 rounded badge status_badge bg-primary">{{ __(\App\Models\Invoice::$statues[$invoice->status]) }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6">
                                                <div class="text-center">
                                                    <h6>{{__('There is no recent invoice')}}</h6>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card" style="height: 395px">
                        <div class="card-body">
                            <ul class="nav nav-pills mb-5" id="pills-tab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" href="#invoice_weekly_statistics" role="tab" aria-controls="pills-home" aria-selected="true">{{__('Invoices Weekly Statistics')}}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" href="#invoice_monthly_statistics" role="tab" aria-controls="pills-profile" aria-selected="false">{{__('Invoices Monthly Statistics')}}</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="invoice_weekly_statistics" role="tabpanel" aria-labelledby="pills-home-tab">
                                    <div class="table-responsive">
                                        <table class="table align-items-center mb-0 ">
                                            <tbody class="list">
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Invoice Generated')}}</p>

                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyInvoice['invoiceTotal'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Paid')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyInvoice['invoicePaid'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Due')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyInvoice['invoiceDue'])}}</h4>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="invoice_monthly_statistics" role="tabpanel" aria-labelledby="pills-profile-tab">
                                    <div class="table-responsive">
                                        <table class="table align-items-center mb-0 ">
                                            <tbody class="list">
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Invoice Generated')}}</p>

                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyInvoice['invoiceTotal'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Paid')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyInvoice['invoicePaid'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Due')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyInvoice['invoiceDue'])}}</h4>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mt-1 mb-0">{{__('Recent Bills')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('Vendor')}}</th>
                                        <th>{{__('Bill Date')}}</th>
                                        <th>{{__('Due Date')}}</th>
                                        <th>{{__('Amount')}}</th>
                                        <th>{{__('Status')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($recentBill as $bill)
                                        <tr>
                                            <td>{{\Auth::user()->billNumberFormat($bill->bill_id)}}</td>
                                            <td>{{!empty($bill->vender_name)? $bill->vender_name : '-' }} </td>
                                            <td>{{ Auth::user()->dateFormat($bill->bill_date) }}</td>
                                            <td>{{ Auth::user()->dateFormat($bill->due_date) }}</td>
                                            <td>{{\Auth::user()->priceFormat($bill->getTotal())}}</td>
                                            <td>
                                                @if($bill->status == 0)
                                                    <span class="p-2 px-3 status_badge rounded badge bg-secondary">{{ __(\App\Models\Bill::$statues[$bill->status]) }}</span>
                                                @elseif($bill->status == 1)
                                                    <span class="p-2 px-3 status_badge rounded badge bg-warning">{{ __(\App\Models\Bill::$statues[$bill->status]) }}</span>
                                                @elseif($bill->status == 2)
                                                    <span class="p-2 px-3 status_badge rounded badge bg-danger">{{ __(\App\Models\Bill::$statues[$bill->status]) }}</span>
                                                @elseif($bill->status == 3)
                                                    <span class="p-2 px-3 status_badge rounded badge bg-info">{{ __(\App\Models\Bill::$statues[$bill->status]) }}</span>
                                                @elseif($bill->status == 4)
                                                    <span class="p-2 px-3 status_badge rounded badge bg-primary">{{ __(\App\Models\Bill::$statues[$bill->status]) }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6">
                                                <div class="text-center">
                                                    <h6>{{__('There is no recent bill')}}</h6>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-5">
                    <div class="card" style="height: 395px">
                        <div class="card-body">
                            <ul class="nav nav-pills mb-5" id="pills-tab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" href="#bills_weekly_statistics" role="tab" aria-controls="pills-home" aria-selected="true">{{__('Bills Weekly Statistics')}}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" href="#bills_monthly_statistics" role="tab" aria-controls="pills-profile" aria-selected="false">{{__('Bills Monthly Statistics')}}</a>
                                </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="bills_weekly_statistics" role="tabpanel" aria-labelledby="pills-home-tab">
                                    <div class="table-responsive">
                                        <table class="table align-items-center mb-0 ">
                                            <tbody class="list">
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Bill Generated')}}</p>

                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyBill['billTotal'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Paid')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyBill['billPaid'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Due')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($weeklyBill['billDue'])}}</h4>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="bills_monthly_statistics" role="tabpanel" aria-labelledby="pills-profile-tab">
                                    <div class="table-responsive">
                                        <table class="table align-items-center mb-0 ">
                                            <tbody class="list">
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Bill Generated')}}</p>

                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyBill['billTotal'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Paid')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyBill['billPaid'])}}</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <h5 class="mb-0">{{__('Total')}}</h5>
                                                    <p class="text-muted text-sm mb-0">{{__('Due')}}</p>
                                                </td>
                                                <td>
                                                    <h4>{{\Auth::user()->priceFormat($monthlyBill['billDue'])}}</h4>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>{{__('Goal')}}</h5>
                        </div>
                        <div class="card-body">
                            @forelse($goals as $goal)
                                @php
                                    $total= $goal->target($goal->type,$goal->from,$goal->to,$goal->amount)['total'];
                                    $percentage=$goal->target($goal->type,$goal->from,$goal->to,$goal->amount)['percentage'];
                                    $per=number_format($goal->target($goal->type,$goal->from,$goal->to,$goal->amount)['percentage'], Utility::getValByName('decimal_number'), '.', '');
                                @endphp
                                <div class="card border-success border-2 border-bottom-0 border-start-0 border-end-0">
                                    <div class="card-body">
                                        <div class="form-check p-0">
                                            <label class="form-check-label d-block" for="customCheckdef1">
                                                <span>
                                                    <span class="row align-items-center">
                                                        <span class="col">
                                                            <span class="text-muted text-sm d-block mb-1">{{__('Name')}}</span>
                                                            <h6 class="text-nowrap mb-3 mb-sm-0">{{$goal->name}}</h6>
                                                        </span>
                                                        <span class="col">
                                                            <span class="text-muted text-sm d-block mb-1">{{__('Type')}}</span>
                                                            <h6 class="mb-3 mb-sm-0">{{ __(\App\Models\Goal::$goalType[$goal->type]) }}</h6>
                                                        </span>
                                                        <span class="col">
                                                            <span class="text-muted text-sm d-block mb-1">{{__('Duration')}}</span>
                                                            <h6 class="mb-3 mb-sm-0">{{$goal->from .' To '.$goal->to}}</h6>
                                                        </span>
                                                        <span class="col">
                                                            <span class="text-muted text-sm d-block mb-1">{{__('Target')}}</span>
                                                            <h6 class="mb-3 mb-sm-0">{{\Auth::user()->priceFormat($total).' of '. \Auth::user()->priceFormat($goal->amount)}}</h6>
                                                        </span>
                                                        <span class="col">
                                                            <span class="text-muted text-sm d-block mb-1">{{__('Progress')}}</span>
                                                            <h6 class="mb-2 d-block">{{number_format($goal->target($goal->type,$goal->from,$goal->to,$goal->amount)['percentage'], Utility::getValByName('decimal_number'), '.', '')}}%</h6>
                                                            <div class="progress mb-0">
                                                                @if($per<=33)
                                                                    <div class="progress-bar bg-danger" style="width: {{$per}}%"></div>
                                                                @elseif($per>=33 && $per<=66)
                                                                    <div class="progress-bar bg-warning" style="width: {{$per}}%"></div>
                                                                @else
                                                                    <div class="progress-bar bg-primary" style="width: {{$per}}%"></div>
                                                                @endif
                                                            </div>
                                                        </span>
                                                    </span>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @empty
                                <div class="card pb-0">
                                    <div class="card-body text-center">
                                        <h6>{{__('There is no goal.')}}</h6>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script-page')
    <script>
        if(window.innerWidth <= 500)
        {
            $('p').removeClass('text-sm');
        }
    </script>
@endpush
